<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ref_list_uang_masuk extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('list_uang_masuk_model', 'uang_masuk');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu'; 
    }
	
	public function index()
	{
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
			
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a style=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"edit_view('+row.id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-lg fa-fw fa-edit\"></i>\
								  </a>";
			}

			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a style=\"margin:4px;\" class=\"btn btn-danger btn-xs\" onclick=\"delete_data('+row.id+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-lg fa-fw fa-trash-o\"></i>\
								</a>"; 
			}			
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					'psize'  		=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 		=> $create_button,
					'update' 		=> $update_button,
					'delete'		=> $delete_button
			);
			
			$this->load->view('ref_list_uang_masuk_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}	
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);
			$options_desk = $this->uang_masuk->get_desk();
			if (!empty($id)) {
				
				if ($this->gparam['privilage']->privilage_update == 'Y') {
					$data['header'] = 'Edit List Uang Masuk';
					$data['submit'] = 'update';
					$data['id']		= $id;
					
					//get data 
					$edit = $this->uang_masuk->get_value_edit($id);
					
					$kodedesk = '<label class="select"><select name="kodedesk">';
						
						$kodedesk .= '<option value="">--Select--</option>';
						foreach ($options_desk as $options) {
							if ($options['kodedesk'] == $edit->kodedesk) {
								$kodedesk .= '<option value="'.$options['kodedesk'].'" selected>'.$options['deskripsi'].'</option>';
							} else {
								$kodedesk .= '<option value="'.$options['kodedesk'].'">'.$options['deskripsi'].'</option>';
							}						
						}			
						$kodedesk .= '</select><i></i></label>';
						
					$data['kodedesk']	= $kodedesk;  
					$data['kodesub']	= $edit->kodesub;  
					$data['keterangan']	= $edit->keterangan;  
					$data['daftarlist']	= $edit->daftarlist;  
				} else {
					echo $this->gparam['restrict']; die();
				}
			} else {
				
				if ($this->gparam['privilage']->privilage_create == 'Y') {
					$data['header'] = 'Add New List Uang Masuk';
					$data['submit'] = 'create';	
					$kodedesk = '<label class="select"><select name="kodedesk">';
						
						$kodedesk .= '<option value="">--Select--</option>';
						foreach ($options_desk as $options) {
							$kodedesk .= '<option value="'.$options['kodedesk'].'">'.$options['deskripsi'].'</option>';	
						}	
					
					$kodedesk .= '</select><i></i></label>';
					$data['kodedesk'] = $kodedesk;
				} else {
					echo $this->gparam['restrict']; die();
				}				
			}
			$this->load->view('crud_ref_list_uang_masuk',$data);
		} else {
			echo $this->gparam['restrict'];
		}	
	}
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->uang_masuk->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->uang_masuk->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	public function delete() {
		
		$delete = $this->uang_masuk->delete_data();
		if ($delete) {
			$json = true;
		}
		echo json_encode($json);	
	}
	
	function load_data() {
		header('Content-Type: application/jsonp');
        $list = $this->uang_masuk->get_list_data();
		
        echo json_encode($list);
	}
	
	
}
