<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adm_role extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('role_model', 'role');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
			
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				
				//create button
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a style=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"edit_view('+row.role_id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-lg fa-fw fa-edit\"></i>\
								  </a>";
			}

			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a style=\"margin:4px;\" class=\"btn btn-danger btn-xs\" onclick=\"delete_data('+row.role_id+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-lg fa-fw fa-trash-o\"></i>\
								</a>"; 
			}				
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 		=> $create_button,
					'update' 		=> $update_button,
					'delete'		=> $delete_button
			);
			
			$this->load->view('role_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);	
			
			if (!empty($id)) {
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					//get value for edit
					$edit = $this->role->get_value_edit($id);
					$role_status = $edit->role_status;
					
					if ($role_status == 'Y') {
						$value = '<option value="Y" selected>Valid</option>
								  <option value="N">Invalid</option>';
					} else if ($role_status == 'N') {
						$value = '<option value="Y">Valid</option>
								  <option value="N" selected>Invalid</option>';	
					} else {
						$value = '<option value="Y">Valid</option>
								  <option value="N">Invalid</option>';
					}
					
					$data['role_name'] = $edit->role_name;			
					$data['role_id'] = $id;
					$status = '<label class="select">
									<select name="role_status">
										<option value="">--Select--</option>
										'.$value.'									
									</select> <i></i> 
								</label>';
					$data['header'] = 'Edit Role';
					$data['submit'] = 'update';	
				} else {
					echo $this->gparam['restrict']; die();
				}	
			} else {
				if ($this->gparam['privilage']->privilage_create == 'Y') {	
					$status = '<label class="select">
									<select name="role_status">
										<option value="">--Select--</option>
										<option value="Y">Valid</option>
										<option value="N">Invalid</option>									
									</select> <i></i> 
								</label>';
					$data['header'] = 'Add New Role';
					$data['submit'] = 'create';
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			
			$data['status'] = $status;
			$this->load->view('crud_role_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}	
	
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->role->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->role->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	function cek_role() {
		
		$id = "";
		$role 	= $this->input->post('role_name');
		$id 	= $this->input->post('role_id');
		
		//echo $role."--".$id; die(); 
		if ($id == "") {
			$cek = $this->role->cekRoleName($role);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		} else {
			$cek = $this->role->cekRoleNameUpdate($role,$id);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		}
		
		echo json_encode($json);		
	}
	
	public function delete() {
		
		$delete = $this->role->delete_data();
		if ($delete) {
			$json = true;
		}
		echo json_encode($json);	
	}
	
	function load_data() {
		header('Content-Type: application/jsonp');
        $list = $this->role->get_list_data();
		
        echo json_encode($list);
	}
	
	
}
