<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rep_uang_keluar_thn extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('rep_uang_keluar_model_thn', 'rep');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	
	public function index()	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$act = base_url()."index.php/".$this->gparam['controller']."/load_data";
			
			$excell_download = '<a class="btn btn-success" id="save_excell" href="#" >
								<i class="fa fa-lg fa-fw fa-download"></i>Excell
							  </a>';		

			
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					/* 'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					 */
					 'excell' 		=> $excell_download,
					'action'		=> $act
			);
			
			$this->load->view('rep_uang_keluar_view_thn',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	function load_data() {
	
		/* $periode = $this->input->post("periode");
		$until = $this->input->post("until");
	    $get_id_siswa = $this->rep_sis->get_id_siswa($peride,$until);
		 */
		
		$periode = $this->input->post("periode");	
		$get_data = $this->rep->get_data($periode);
		$date = new DateTime($periode);
		$resultM = $date->format('m');
		$resultY = $date->format('Y');
		
		/*Header*/
		$html = '<table class="table table-bordered" id="activity_table"><thead>';
		
		$html .='<tr ><td colspan="3"><center><b>PESAT</b></center></td></tr>';
		$html .='<tr ><td colspan="3"><center><b>Laporan Uang Keluar Tahunan (Tahun: '.$resultY.')</b></center></td></tr>';
		$html .='<tr ><td colspan="3"></td></tr>';
		
		$html .='<tr><th style="text-align:center;">No</th>';
		$html .='<th style="text-align:center;">Nama Transaksi</th>';
		$html .='<th style="text-align:center;">Besarnya</th>';		
		
		$html .= '</tr></thead>';
		$html .= '<tbody>';
		$i = 1;
		$total = 0;
		foreach ($get_data as $v_data) {
			$total = $total + $v_data['besarnya'];
			$html .='<tr>';
			$html .='<td>'.$i.'</td>';
			$html .='<td>'.$v_data['daftarlist'].'</td>';
			$html .='<td style="text-align:right;">Rp. '.number_format($v_data['besarnya'],2,",",".").'</td>';			
			$html .='</tr>';
			$i++;
		}
		$html .='<tr>
			<td colspan="2" style="text-align:right; padding-right:100px; font-size:15px; font-weight: bold;">JUMLAH</td>
			<td style="text-align:right;">Rp. '.number_format($total,2,",",".").'</td>
		</tr>';
		
		$html .= '</tbody>';
		$html .= '</table>';
		$html .= '<script>
					var name = "report_uang_keluar_tahunan_'.$resultY.'.xls";
					$("#save_excell").on("click", function () {
						var uri = $("#activity_table").btechco_excelexport({
						containerid: "activity_table"
						, datatype: $datatype.Table
						, returnUri: true
						});
				$(this).attr("download", name).attr("href", uri).attr("target", "_blank");
			});
		</script>';
		echo $html;
	}
	
	
}
