<?php 
class Ref_biaya_model extends CI_Model {
	
	function get_list_coa($table) {
		
		$this->db->select("id,kodedesk,kodesub,daftarlist");
		$this->db->from($table);
		$this->db->order_by("kodedesk","asc");
		$data = $this->db->get()->result_array();		
		return $data;
		
	}
	
	function getDataSMK(){
		$this->db->select('*');
		$this->db->from("ref_smk");
		$num = $this->db->get()->result_array();
		return $num;
	}
	function cekKelas(){
		$return='';
		$this->db->select('*');
		$this->db->from("ref_kelas");
		$num = $this->db->get()->result_array();
		
		foreach ($num as $v_kls) {
			$return.='<option value="'.$v_kls['kelas'].'">Kelas '.$v_kls['kelas'].'</option>';
		}
								
		return $return;
	}
	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("ref_list_biaya");
			
		}
		
		return $del;
	}
	
	function get_value_edit($id) {
		$this->db->select('*');
		$this->db->from('ref_list_biaya');
		$this->db->where('id',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	function getKelas($smk){
		$this->db->select('*');
		$this->db->from("ref_kelas");
		$this->db->where('id_smk',$smk);
		$num = $this->db->get()->result_array();
		return $num;
	}
	function getKelasSMK($smk){
		$return = '';
		$q = $this->db->query("SELECT * FROM ref_kelas WHERE id_smk='".$smk."'");
		
		$data = $q->result_array();
		foreach ($data as $val) {
			$return .='<option value="'.$val['kelas'].'">'.$val['kelas'].'</option>';
		} 
		return $return;
	}
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
				
				// declare variable
				if($rule['field']=='smk'){
					$field = 'b.name';
				}else{
					$field = $rule['field'];
				}
				
                // declare variable
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'ref_list_biaya'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
				
                $sql = "select a.*, b.name as smk from $table a, ref_smk b where a.id_smk=b.id order by b.name, a.kelas, id limit ?, ?";
                $sqlcount = "select a.*, b.name as smk from $table a, ref_smk b where a.id_smk=b.id";
            } else {
                $sql = "select a.*, b.name as smk from $table a, ref_smk b $cond and a.id_smk=b.id order by b.name, a.kelas, id limit ?, ?";
                $sqlcount = "select a.*, b.name as smk from $table a, ref_smk b $cond and a.id_smk=b.id";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select a.*, b.name as smk from $table a, ref_smk b where a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "select a.*, b.name as smk from $table a, ref_smk b where a.id_smk=b.id";
            } else {
                $sql = "select a.*, b.name as smk from $table a, ref_smk b  $cond and  a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "select a.*, b.name as smk from $table a, ref_smk b $cond and a.id_smk=b.id";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	function insert_data() {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		$data['id_smk'] 		= $this->input->post('smk');
		$data['kelas'] 		= $this->input->post('kelas');
		$data['periode'] 		= $this->input->post('periode');
		
		$data['jenispembayaran'] 		= $this->input->post('jenispembayaran');
		$data['besarnya']				= $this->input->post('besarnya');
		$data['id_coa']					= $this->input->post('id_coa');
		$data['dicicil']				= $this->input->post('dicicil');
		$data['jenis_transaksi']		= $this->input->post('jenis_transaksi');
		$data['dana_opsional']			= $this->input->post('opsional');
		$data['created_date']			= date("Y-m-d H:i:s");
		$data['created_by']				= $this->session->userdata('username');
		$data['tahun_ajaran']			= $tahun_ajaran;
		
		$q = $this->db->insert("ref_list_biaya",$data);
		return $q;	
		
	}
	
	function update_data() {
		
		$id = $this->input->post("id");
		$tahun_ajaran = $this->get_tahun_ajaran();
		
		$data['id_smk'] 				= $this->input->post('smk');
		$data['kelas'] 					= $this->input->post('kelas');
		$data['periode'] 				= $this->input->post('periode');
		$data['dana_opsional']			= $this->input->post('opsional');
		$data['jenispembayaran'] 		= $this->input->post('jenispembayaran');
		$data['besarnya']				= $this->input->post('besarnya');
		$data['id_coa']					= $this->input->post('id_coa');
		$data['dicicil']				= $this->input->post('dicicil');
		$data['jenis_transaksi']		= $this->input->post('jenis_transaksi');
		$data['modified_date']			= date("Y-m-d H:i:s");
		$data['modified_by']			= $this->session->userdata('username');
		$data['tahun_ajaran']			= $tahun_ajaran;
		
		$this->db->where("id",$id);
		$q = $this->db->update("ref_list_biaya",$data);
		return $q;	
		
	}
	
	function get_tahun_ajaran() {
		
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$this->db->where("sts_ppdb","1");
		$data = $this->db->get()->row()->tahun_ajaran;
		return $data;
		
	}
	
}