<?php
function ctword($x) 
{
	$x = abs($x);
	$number = array("", "satu", "dua", "tiga", "empat", "lima",
	"enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
	$temp = "";

	if ($x <12) {
	$temp = " ". $number[$x];
	} else if ($x <20) {
	$temp = ctword($x - 10). " belas";
	} else if ($x <100) {
	$temp = ctword($x/10)." puluh". ctword($x % 10);
	} else if ($x <200) {
	$temp = " seratus" . ctword($x - 100);
	} else if ($x <1000) {
	$temp = ctword($x/100) . " ratus" . ctword($x % 100);
	} else if ($x <2000) {
	$temp = " seribu" . ctword($x - 1000);
	} else if ($x <1000000) {
	$temp = ctword($x/1000) . " ribu" . ctword($x % 1000);
	} else if ($x <1000000000) {
	$temp = ctword($x/1000000) . " juta" . ctword($x % 1000000);
	} else if ($x <1000000000000) {
	$temp = ctword($x/1000000000) . " milyar" . ctword(fmod($x,1000000000));
	} else if ($x <1000000000000000) {
	$temp = ctword($x/1000000000000) . " trilyun" . ctword(fmod($x,1000000000000));
	}
	return $temp;
}

function terbilang($x,$style=4,$strcomma=",") 
{
	if($x<0) {
	$result = "minus ". trim(ctword($x));
	} else {
	$arrnum=explode("$strcomma",$x);
	$arrcount=count($arrnum);
	if ($arrcount==1){
	$result = trim(ctword($x));
	}else if ($arrcount>1){
	$result = trim(ctword($arrnum[0])) . " koma " . trim(ctword($arrnum[1]));
	}
	}
	switch ($style) {
	case 1: //1=uppercase  dan
	$result = strtoupper($result);
	break;
	case 2: //2= lowercase
	$result = strtolower($result);
	break;
	case 3: //3= uppercase on first letter for each word
	$result = ucwords($result);
	break;
	default: //4= uppercase on first letter
	$result = ucfirst($result);
	break;
	}
	return $result;
}

class PDF extends FPDF
{
	var $diserahkan;
	var $diterima;
	
    function diserahkan($diserahkan){
        $this->diserahkan=strtoupper($diserahkan);
    }
	function diterima($diterima){
        $this->diterima=strtoupper($diterima);
    }
	//Page header
	/*
	function Header()
	{
	    //Logo
		//$this->Image('style/logobesar.png',12,10,25);
		//Arial bold 15
		$this->SetFont('courier','',9);
		//Move to the right
		$this->Cell(0,0,'..........................................................................................................',0,1,2);
		
		$this->Cell(0,11,'YAYASAN PESAT BIRRUL WALIDAIN',0,1,1);
		$this->Cell(0,8,'SMP/SMA/SMK PESAT',0,1,1);
		//$this->Cell(0,8,'',0,1,1);
		$this->SetY(12);
		$this->SetX(120);
		$this->Cell(0,8,'Alamat :',0,1,1);
		$this->SetX(120);
		$this->Cell(0,8,'Jln. Poras No.7 Sindang Barang Loji Bogor',0,1,1);
		//$this->SetX(120);
		//$this->Cell(0,8,'Telpon.  (0251) 8627289',0,1,1);
		$this->Cell(0,3,'..........................................................................................................',0,1,2);
		//Title
		$this->SetY(26);
		$this->SetX(95);
		$this->SetFont('courier','',12);
		$this->Cell(0,22,'TANDA TERIMA',0,1,1);
		
		$this->SetY(27);
		$this->SetX(95);
		$this->Cell(0,22,'____________',0,1,1);
		
		//Line break
		$this->Ln(5);
                
	}	*/
	
	function Footer() {
			global $diserahkan;
			global $diterima;
			$left_pos_X=28;
			$left_pos_Y=105;
			$this->Ln(0);
			$this->SetFont('Arial','',10);
			
			
		
		
			//Position at 1.5 cm from bottom
			//$this->Ln(5);
			//Arial italic 8
			$this->SetFontSpacing(3.5);
			//Page number
			$this->Ln(8);
			$this->SetY($left_pos_Y);
			$this->SetX($left_pos_X);
			
			
			$this->Cell(0,0,'Pembayar,',0,1);
			
			$this->SetX($left_pos_X+115);
			$this->Cell(0,0,'Teller,',0,1);
			
			$this->SetX($left_pos_X);
			$this->Cell(0,0,'',0,1);
			$this->Ln(18);
			$this->SetX($left_pos_X);
			
			if(strlen($this->diserahkan)<=28){
				$trbilang = substr($this->diserahkan, 0, strlen($this->diserahkan));
				$this->Cell(0,0,'('.$trbilang.')',0,1);
			}else{
				$this->Cell(0,0,'('.substr($this->diserahkan, 0, 28).".)",0,1);
			}
			
			$this->SetX($left_pos_X+115);
			$this->Cell(0,0,'('.$this->diterima.')',0,1);
			//$this->SetX(10);
			//$this->Cell(0,0,'____________________________',0,1);
			
			/*
			$this->SetFont('Arial','',9);
			$this->SetY($left_pos_Y);
			$this->Ln(6);
			$this->SetX($left_pos_X+8);
			$this->SetFontSpacing(3);
			$this->Cell(0,0,'Dengan ditandatanganinya kwitansi ini, pembayar telah',0,1);
			
			$this->Ln(3);
			$this->SetX($left_pos_X-2);
			$this->Cell(0,0,'menyetujui kebenaran jumlah dan alokasi dana yang dibayarkan',0,1);
			
			$this->Ln(5);
			$this->SetX($left_pos_X+50);
			$this->Cell(0,0,'---Terima Kasih---',0,1);
		*/
		
	}
}
 
	//Instanciation of inherited class
	$pdf=new PDF();
	$this->load->model('trans_spp_ppdb_model', 'trans_siswa');
	$getSiswaFaktur = $this->trans_siswa->getSiswaFaktur($faktur);
	$getDetSiswaFaktur = $this->trans_siswa->getDetSiswaFaktur($getSiswaFaktur->id_siswa,$getSiswaFaktur->sts_ppdb);
	$left_pos_X=28;
 	$left_pos_Y=11;
	$pdf->diserahkan($diserahkan);
	$pdf->diterima($diterima);
	$pdf->AliasNbPages();
	$pdf->AddPage();
	
	
	
	$pdf->Image('image/cap/CAP_KEU.png', 125, 105, $fpdf->w, 20);
	
	
	$files = glob('image/ttd/*');
    $sts_ttd=0;
    // Loop through the array of files
    foreach($files as $file) {
        // Output each file name on a new line
        if (strcmp(strtolower(substr($file,10)), strtolower($diterima))==0){
            //echo substr($file,10)."<br>"; 
            $sts_ttd=1;
        }
    }
    if($sts_ttd==1){
        $pdf->Image('image/ttd/'.strtolower($diterima).'/'.strtolower($diterima).'.png', 140, 100, $fpdf->w, 30);
    }else{
        $pdf->Image('image/ttd/no_img.png', 145, 107, $fpdf->w, 15);
    }
    
    
	$pdf->SetFont('Arial','B',10);
	$pdf->SetFontSpacing(4);
	$pdf->SetY($left_pos_Y);
	$pdf->SetX($left_pos_X+19);
	
	//$pdf->Cell(0,0,'telah terima dari '.$diserahkan,0,1);
	$pdf->Cell(0,0,'YAYASAN PESAT BIRRUL WALIDAIN',0,1);
	$pdf->Ln(4);
	$pdf->SetX($left_pos_X+18.5);
	$pdf->Cell(0,0,'SMP-SMA-SMK INFORMATIKA PESAT',0,1);
	$pdf->Ln(4);
	$pdf->SetX($left_pos_X+8);
	$pdf->Cell(0,0,'Jl. Poras No.7 Sindang Barang Loji - Bogor',0,1);
	
	$pdf->SetFont('Arial','',10);
	$pdf->Ln(3);
	$pdf->SetFontSpacing(4);
	//$pdf->SetX($left_pos_X);
	//$pdf->Cell(0,0,'uang sejumlah  # '.terbilang($total,$style=3,$strcomma=",").' Rupiah #',0,1);
	//$pdf->Ln(7);
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX($left_pos_X);
	$pdf->Cell(0,0,'----------------------------------------------------------',0,1);
	$pdf->Ln(3);
	$pdf->SetFont('Arial','',10);
	$pdf->SetX($left_pos_X+8);
	date_default_timezone_set("Asia/Jakarta");
	$pdf->Cell(0,0,'No. ' .$faktur.' '.date("d/m/Y").' '.date("h:i:sa"),0,1);
	/*
	$pdf->Cell(0,0,'No. ' .$faktur.' '.date("d/m/Y").' '.date("h:i:sa"),0,1);
	$pdf->Ln(4);
	$pdf->Cell(0,0,date("d/m/Y").' '.date("h:i:sa"),0,1);
	$pdf->Ln(4);
	$pdf->SetX($left_pos_X+83);
	$pdf->Cell(0,0,'IDR '.number_format($total,0,',' ,'.').',00',0,1);
	*/
	$pdf->Ln(7);
	//$pdf->SetFont('courier','B',10);
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX($left_pos_X+49);
	$pdf->Cell(0,0,'BUKTI PEMBAYARAN',0,1);
	$pdf->Ln(0);
	$pdf->SetFont('courier','B',10);
	$pdf->Ln(5);
	$pdf->SetFontSpacing(4);
	$pdf->SetX($left_pos_X);
	$pdf->SetFont('Arial','',10);
	$pdf->Cell(0,0,'Tgl. Transaksi',0,1);
	$pdf->SetX($left_pos_X+45);
	$pdf->Cell(0,0,':',0,1);
	$pdf->SetX($left_pos_X+49);
	
	
		$NamaMetodePembayaran = $this->trans_siswa->getNamaMetodePembayaran($getSiswaFaktur->id_jenis_bayar);
	
	$pdf->Cell(0,0,date("d-M-Y", strtotime($getSiswaFaktur->tanggal_transaksi))." (melalui: ".$NamaMetodePembayaran.")",0,1);
	$pdf->Ln(4);
	
	$pdf->SetX($left_pos_X);
	$pdf->Cell(0,0,'No. Induk',0,1);
	$pdf->SetX($left_pos_X+45);
	$pdf->Cell(0,0,':',0,1);
	$pdf->SetX($left_pos_X+49);
	$pdf->Cell(0,0,$getDetSiswaFaktur->id,0,1);
	$pdf->Ln(4);
	
	$pdf->SetX($left_pos_X);
	$pdf->Cell(0,0,'Nama',0,1);
	$pdf->SetX($left_pos_X+45);
	$pdf->Cell(0,0,':',0,1);
	$pdf->SetX($left_pos_X+49);
	if(strlen($diserahkan)<=27){
		$trbilang = substr($diserahkan, 0, strlen($diserahkan));
		$pdf->Cell(0,0,$trbilang,0,1);
	}else{
		$pdf->Cell(0,0,substr($diserahkan, 0, 27)."-",0,1);
		$pdf->Ln(3);
		$pdf->SetX($left_pos_X+49);
		$pdf->Cell(0,0,substr($diserahkan, 27, strlen($diserahkan)),0,1);
	}
	$pdf->Ln(4);
	
	$pdf->SetX($left_pos_X);
	$pdf->Cell(0,0,'Asal Sekolah',0,1);
	$pdf->SetX($left_pos_X+45);
	$pdf->Cell(0,0,':',0,1);
	$pdf->SetX($left_pos_X+49);
	$pdf->Cell(0,0,$getAsalSekolah,0,1);
	$pdf->Ln(4);
	
	$pdf->SetX($left_pos_X);
	$pdf->Cell(0,0,'Sekolah',0,1);
	$pdf->SetX($left_pos_X+45);
	$pdf->Cell(0,0,':',0,1);
	$pdf->SetX($left_pos_X+49);
	$pdf->Cell(0,0,$this->trans_siswa->getSMKFaktur($getDetSiswaFaktur->id_smk),0,1);
	$pdf->Ln(6);
	
	$pdf->SetX($left_pos_X);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(0,0,'URAIAN :',0,1);
	$pdf->Ln(3);
	/*
	
	$pdf->SetFont('courier','B',10);
	//$pdf->SetY(10);
	$pdf->SetX(45);
	//$faktur=date('dmy',strtotime($vdate)).'-'.$data['nofaktur'];
	
	$pdf->Cell(0,0,'Nomor Faktur ',0,1);
	$pdf->SetX(80);	
	$pdf->Cell(0,-25,'		:		' .$faktur,0,1);
	//$pdf->Cell(0,45,'No : FM2016021500003',0,1,2);	
	$pdf->SetY(22);
	$pdf->SetX(45);
	$pdf->Cell(0,0,'Sudah terima dari  ',0,1,1);
	$pdf->SetX(80);
	$pdf->Cell(0,0,'		:		' .$diserahkan,0,1);
	//$pdf->Cell(0,0,'		:		Ujang',0,1);
	$pdf->SetY(20.4);
	$pdf->SetX(45);
	$pdf->Cell(0,11.5,'Banyaknya  ',0,1);
	$pdf->SetX(80);
	$pdf->Cell(0,-10.7,'		:		'.terbilang($total,$style=3,$strcomma=",").' Rupiah',0,1);
	$pdf->SetY(19);
	$pdf->SetX(45);
	$pdf->Cell(0,23,'Keterangan  ',0,1);
	$pdf->SetX(80);
	$pdf->Cell(0,-22.5,'		:		' ,0,1);
	$pdf->SetY(29);
	$pdf->SetX(90.5);
	*/
	
	$count_detail = count($detail);
	$j = 0;
	$mod = 6;
	//content
	foreach ($detail as $val) {
		$pdf->SetFont('Arial','',10);
		$pdf->SetX($left_pos_X);
		$pdf->SetFontSpacing(3);
		 
		$pdf->SetX($left_pos_X);
		$pdf->SetX($left_pos_X);
		$pdf->Cell(0,4.5,($j+1).'.'.$val['det'].' '.$val['bulan'].' '.$val['tahun_ajaran'],0,'C');	
		
		
		
		
		if(strlen($val['besarnya'])<=5){
			$pdf->SetX($left_pos_X+115);
		}else if(strlen($val['besarnya'])==6){
			$pdf->SetX($left_pos_X+112);
		}else if(strlen($val['besarnya'])==7){
			$pdf->SetX($left_pos_X+107);
		}else if(strlen($val['besarnya'])>7){
			$pdf->SetX($left_pos_X+102);
		}
		$pdf->Cell(0,4.5, number_format($val['besarnya'],0,',','.').',00',0,'C');	
		$pdf->Ln(-1);
		
			
		$j++;
		$res = fmod($j,$mod);
		if ($res == 0) {
			
			
			$pdf->Ln(4);
			$pdf->SetFont('courier','B',10);
			$pdf->SetFontSpacing(0);
			$pdf->SetX($left_pos_X+104);
			$pdf->Cell(0,0,'_________________ +',0,1);
			
			$pdf->Ln(5);
			$pdf->SetFont('Arial','B',10);
			//$pdf->Cell(0,10,'..........................................................................................................',0,1,2);
			//$pdf->SetX(25);
			//$pdf->Cell(0,8,'',0,1,2);
			$pdf->SetFontSpacing(3);
			$pdf->SetX($left_pos_X);
			$pdf->Cell(0,0,'TOTAL  :',0,1);
			
			
			
			if(strlen($total)<=5){
				$pdf->SetX($left_pos_X+115);
			}else if(strlen($total)==6){
				$pdf->SetX($left_pos_X+112);
			}else if(strlen($total)==7){
				$pdf->SetX($left_pos_X+107);
			}else if(strlen($total)>7){
				$pdf->SetX($left_pos_X+102);
			}
			$pdf->Cell(0,0,number_format($total,0,',' ,'.').',00',0,1);
			
			
			$pdf->Ln(5);
			$pdf->SetFont('Arial','',10);
			$pdf->SetX($left_pos_X);
			$pdf->Cell(0,0,'terbilang : ',0,1);
			$pdf->SetX($left_pos_X+35);
			$pdf->SetFont('Arial','I',10);
			$res_bilang = terbilang($total,$style=2,$strcomma=",");
			if(strlen($res_bilang)<=45){
				$trbilang = substr($res_bilang, 0, strlen($res_bilang));
				$pdf->Cell(0,0,$trbilang.' rupiah',0,1);
			}else{
				$pdf->Cell(0,0,substr($res_bilang, 0, 45)."-",0,1);
				$pdf->Ln(5);
				$pdf->SetX($left_pos_X+30);
				$pdf->Cell(0,0,substr($res_bilang, 45, strlen($res_bilang)).' rupiah',0,1);
			}
			//$pdf->SetX(137);
			//$pdf->Cell(0,-18,': Rp.'.number_format($total,0,',' ,'.'),0,1);
			//$pdf->Cell(0,0,': Rp. 2.000.000',0,1);
			
			
			
			
		//$pdf->Cell(0,0,': Rp. 2.000.000',0,1);
		
		//$pdf->SetX(132);
		//$pdf->Cell(0,15,'...............................',0,1,2);
		$pdf->Ln(0);
	
			
			if($j<$count_detail){
				$pdf->AddPage();
				$pdf->SetFont('Arial','B',10);
				$pdf->SetFontSpacing(4);
				$pdf->SetY($left_pos_Y);
				$pdf->SetX($left_pos_X+19);
				
				//$pdf->Cell(0,0,'telah terima dari '.$diserahkan,0,1);
				$pdf->Cell(0,0,'YAYASAN PESAT BIRRUL WALIDAIN',0,1);
				$pdf->Ln(4);
				$pdf->SetX($left_pos_X+18.5);
				$pdf->Cell(0,0,'SMP-SMA-SMK INFORMATIKA PESAT',0,1);
				$pdf->Ln(4);
				$pdf->SetX($left_pos_X+8);
				$pdf->Cell(0,0,'Jl. Poras No.7 Sindang Barang Loji - Bogor',0,1);
				
				$pdf->SetFont('Arial','',10);
				$pdf->Ln(3);
				$pdf->SetFontSpacing(4);
				//$pdf->SetX($left_pos_X);
				//$pdf->Cell(0,0,'uang sejumlah  # '.terbilang($total,$style=3,$strcomma=",").' Rupiah #',0,1);
				//$pdf->Ln(7);
				$pdf->SetFont('Arial','B',10);
				$pdf->SetX($left_pos_X);
				$pdf->Cell(0,0,'----------------------------------------------------------',0,1);
				$pdf->Ln(3);
				$pdf->SetFont('Arial','',10);
				$pdf->SetX($left_pos_X+8);
				date_default_timezone_set("Asia/Jakarta");
				$pdf->Cell(0,0,'No. ' .$faktur.' '.date("d/m/Y").' '.date("h:i:sa"),0,1);
				/*
				$pdf->Cell(0,0,'No. ' .$faktur.' '.date("d/m/Y").' '.date("h:i:sa"),0,1);
				$pdf->Ln(4);
				$pdf->Cell(0,0,date("d/m/Y").' '.date("h:i:sa"),0,1);
				$pdf->Ln(4);
				$pdf->SetX($left_pos_X+83);
				$pdf->Cell(0,0,'IDR '.number_format($total,0,',' ,'.').',00',0,1);
				*/
				$pdf->Ln(7);
				//$pdf->SetFont('courier','B',10);
				$pdf->SetFont('Arial','B',10);
				$pdf->SetX($left_pos_X+49);
				$pdf->Cell(0,0,'BUKTI PEMBAYARAN',0,1);
				$pdf->Ln(0);
				$pdf->SetFont('courier','B',10);
				$pdf->Ln(5);
				$pdf->SetFontSpacing(4);
				$pdf->SetX($left_pos_X);
				$pdf->SetFont('Arial','',10);
				$pdf->Cell(0,0,'Tgl. Transaksi',0,1);
				$pdf->SetX($left_pos_X+45);
				$pdf->Cell(0,0,':',0,1);
				$pdf->SetX($left_pos_X+49);
				
				
				$pdf->Cell(0,0,date("d-M-Y", strtotime($getSiswaFaktur->tanggal_transaksi)),0,1);
				$pdf->Ln(4);
				
				$pdf->SetX($left_pos_X);
				$pdf->Cell(0,0,'No. Induk',0,1);
				$pdf->SetX($left_pos_X+45);
				$pdf->Cell(0,0,':',0,1);
				$pdf->SetX($left_pos_X+49);
				$pdf->Cell(0,0,$getDetSiswaFaktur->id,0,1);
				$pdf->Ln(4);
				
				$pdf->SetX($left_pos_X);
				$pdf->Cell(0,0,'Nama',0,1);
				$pdf->SetX($left_pos_X+45);
				$pdf->Cell(0,0,':',0,1);
				$pdf->SetX($left_pos_X+49);
				if(strlen($diserahkan)<=27){
					$trbilang = substr($diserahkan, 0, strlen($diserahkan));
					$pdf->Cell(0,0,$trbilang,0,1);
				}else{
					$pdf->Cell(0,0,substr($diserahkan, 0, 27)."-",0,1);
					$pdf->Ln(3);
					$pdf->SetX($left_pos_X+49);
					$pdf->Cell(0,0,substr($diserahkan, 27, strlen($diserahkan)),0,1);
				}
				$pdf->Ln(4);
				
				$pdf->SetX($left_pos_X);
				$pdf->Cell(0,0,'Asal Sekolah',0,1);
				$pdf->SetX($left_pos_X+45);
				$pdf->Cell(0,0,':',0,1);
				$pdf->SetX($left_pos_X+49);
				$pdf->Cell(0,0,$getAsalSekolah,0,1);
				$pdf->Ln(4);
				
				$pdf->SetX($left_pos_X);
				$pdf->Cell(0,0,'Sekolah',0,1);
				$pdf->SetX($left_pos_X+45);
				$pdf->Cell(0,0,':',0,1);
				$pdf->SetX($left_pos_X+49);
				$pdf->Cell(0,0,$this->trans_siswa->getSMKFaktur($getDetSiswaFaktur->id_smk),0,1);
				$pdf->Ln(6);
				
				$pdf->SetX($left_pos_X);
				$pdf->SetFont('Arial','B',10);
				$pdf->Cell(0,0,'URAIAN :',0,1);
				$pdf->Ln(3);
			
			}
		}
		$pdf->Ln();		
		$pdf->SetX(70.5);
		
		
		
	}
	//fmod($count_detail,4)!=0;
	if(($count_detail<6)||((fmod($count_detail,6)!=0)&&($count_detail>6))){
			$pdf->Ln(0);
			$pdf->SetFont('courier','B',10);
			$pdf->SetFontSpacing(0);
			$pdf->SetX($left_pos_X+104);
			$pdf->Cell(0,0,'_________________ +',0,1);
			
			$pdf->Ln(5);
			$pdf->SetFont('Arial','B',10);
			//$pdf->Cell(0,10,'..........................................................................................................',0,1,2);
			//$pdf->SetX(25);
			//$pdf->Cell(0,8,'',0,1,2);
			$pdf->SetFontSpacing(3);
			$pdf->SetX($left_pos_X);
			$pdf->Cell(0,0,'TOTAL  :',0,1);
			
			
			
			if(strlen($total)<=5){
				$pdf->SetX($left_pos_X+115);
			}else if(strlen($total)==6){
				$pdf->SetX($left_pos_X+112);
			}else if(strlen($total)==7){
				$pdf->SetX($left_pos_X+107);
			}else if(strlen($total)>7){
				$pdf->SetX($left_pos_X+102);
			}
			$pdf->Cell(0,0,number_format($total,0,',' ,'.').',00',0,1);
			
			
			$pdf->Ln(5);
			$pdf->SetFont('Arial','',10);
			$pdf->SetX($left_pos_X);
			$pdf->Cell(0,0,'terbilang : ',0,1);
			$pdf->SetX($left_pos_X+35);
			$pdf->SetFont('Arial','I',10);
			$res_bilang = terbilang($total,$style=2,$strcomma=",");
			if(strlen($res_bilang)<=45){
				$trbilang = substr($res_bilang, 0, strlen($res_bilang));
				$pdf->Cell(0,0,$trbilang.' rupiah',0,1);
			}else{
				$pdf->Cell(0,0,substr($res_bilang, 0, 45)."-",0,1);
				$pdf->Ln(5);
				$pdf->SetX($left_pos_X+30);
				$pdf->Cell(0,0,substr($res_bilang, 45, strlen($res_bilang)).' rupiah',0,1);
			}
			//$pdf->SetX(137);
			//$pdf->Cell(0,-18,': Rp.'.number_format($total,0,',' ,'.'),0,1);
			//$pdf->Cell(0,0,': Rp. 2.000.000',0,1);
			
			
			
			
		//$pdf->Cell(0,0,': Rp. 2.000.000',0,1);
		
		//$pdf->SetX(132);
		//$pdf->Cell(0,15,'...............................',0,1,2);
		$pdf->Ln(0);
	}
	
	$pdf->Output($dest='', $name=$faktur."-".$diserahkan.".pdf");
	
	?>