<!-- EasyUI CSS -->
<link href="<?php echo base_url() . "assets/" ?>easyui/themes/bootstrap/easyui.css" rel="stylesheet">
<link href="<?php echo base_url() . "assets/" ?>easyui/themes/icon.css" rel="stylesheet">

	<div class="row">
		<div id="table-content" class="col-lg-12">
			<table id="tbl">
				<div id="tb" style="padding:3px;height:auto;">
					<div style="margin-bottom:0px; max-width:100px;">												
						<?php echo @$create; ?>
					</div>
				</div>
			</table>
		</div>
	</div>

	<div class="row">
		<div class="extra-footer col-lg-12" style="height:25px;"></div>
		<div class="col-lg-12 page-footer-table"></div>
		<!-- only space 
		-->
	</div>

<script>

	var tbl, setup; // setup is flag
    $(document).ready(function () {
		setup = 0;
		tbl = $('#tbl').datagrid({width: '100%'});
        // toolbar action
		var toolbarCostum = $('#tb');	
		// handle when direct update or create
		tbl.datagrid(gridConfigGeneralNoRowNumFixHeight);
		tbl.datagrid({
			pageNumber: '<?php echo $pnumber?>',
			pageSize: '<?php echo $psize?>',
		});
        tbl.datagrid({
            url: '<?php echo site_url('/') . $controller . '/load_data'; ?>',
            title: "Master Data Siswa",
            toolbar: toolbarCostum,
            onLoadSuccess: loadAction, 
			frozenColumns:[[
				{field: 'options', title: 'ACTION', width: 100, halign: 'center', align: 'center', formatter: formatButton},
				{field: 'nama', title: 'Nama Siswa', width: 170, sortable: 'true', halign: 'center', align: 'center'},
				{field: 'nis', title: 'NIS', width: 120, sortable: 'true', halign: 'center', align: 'center', align: 'center'}, 
				{field: 'nama_smk', title: 'Sekolah', width: 100, sortable: 'true', halign: 'center', align: 'center', align: 'center'},
				
				]],	
            columns: [[  
				
					{field: 'nisn', title: 'NISN', width: 100, sortable: 'true', halign: 'center', align: 'center', align: 'center'},
					{field: 'nama_jur', title: 'Jurusan', width: 120, sortable: 'true', halign: 'center', align: 'center', align: 'center'},
				{field: 'kelas', title: 'Kelas', width: 70, sortable: 'true', halign: 'center', align: 'center', align: 'center'},
				{field: 'r_kelas', title: 'Ruang', width: 70, sortable: 'true', halign: 'center', align: 'center', align: 'center'},
					
					//{field: 'jenis_kelamin', title: 'Jenis Kelamin', width: 100, sortable: 'true', halign: 'center', align: 'center', formatter: formatJekel},                 
                   // {field: 'tempat_lahir', title: 'Tempat Lahir', width: 120, sortable: 'true', halign: 'center', align: 'center'},
					//{field: 'tanggal_lahir', title: 'Tanggal Lahir', width: 120, sortable: 'true', halign: 'center', align: 'center'},                
					//{field: 'nama_ayah', title: 'Nama Ayah', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'nama_ibu', title: 'Nama Ibu', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'alamat', title: 'Alamat Orang Tua', width: 300, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'telepon', title: 'Telepon', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'nama_wali', title: 'Nama Wali', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'alamat_wali', title: 'Alamat Wali', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'telepon_wali', title: 'Telepon Wali', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'created_by', title: 'Created By', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'created_date', title: 'Created Date', width: 150, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'modified_by', title: 'Modified By', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'modified_date', title: 'Modified Date', width: 150, sortable: 'true', halign: 'center', align: 'center'},
                    
                ]]
        });
    });
	
	function loadAction() {
		// fix asyn setup and multiple setup
		if (setup == 0){
			tbl.datagrid('enableFilter',
				 [ {
					field: 'created_date',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				},{
					field: 'modified_date',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				},{
					field: 'tanggal_lahir',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				}] 
			);  
			// remove filter option
			$("input[name='options']").remove();
			setup = 1;
		}
		// fix
		//resizeContentDOMFit();
		// filter
		tbl.datagrid('resize', 'fixRowHeight');
	}
	
	 // format date
    function myFormatter(date) {
        var y = date.getFullYear();
        var m = date.getMonth() + 1;
        var d = date.getDate();
        return y + '-' + (m < 10 ? ('0' + m) : m) + '-' + (d < 10 ? ('0' + d) : d);
    }

    // required
    function myParser(s) {
        if (!s)
            return new Date();
        var ss = (s.split('-'));
        var y = parseInt(ss[0], 10);
        var m = parseInt(ss[1], 10);
        var d = parseInt(ss[2], 10);
        if (!isNaN(y) && !isNaN(m) && !isNaN(d)) {
            return new Date(y, m - 1, d);
        } else {
            return new Date();
        }
    }

	//fancy box
	function preview_image(id) {
		 $.ajax({
            url: '<?php echo site_url('/') . $controller . "/get_fancy_image"; ?>',
            type: 'POST',
            async: false,
            data: {id_siswa: id},
            dataType: 'json',
            success: function (result) {
                // var p = result.images;
                var tempFile = [];
                $.each(result.images, function (index, value) {
                    var tempFileElemet = {href: '<?php echo base_url() . DIR_SISWA; ?>' + value.image_name, title: value.image_name};
                    tempFile.push(tempFileElemet);
                });
               
                
				$.fancybox.open(tempFile, {
                    helpers: {
                        thumbs: {
                            width: 75,
                            height: 50
                        }
                    }
                });
            }
        });
	}
	
	function formatJekel (val, row, index) {
		if (row.jenis_kelamin == 'L') {
			return 'Laki-Laki';
		} else {
			return 'Perempuan';
		}
	}
	
	// inline editor on row
    function formatButton(val, row, index) {
      
		var updateBtn = '<?php echo @$update; ?>';
		var scpace = '&nbsp;&nbsp;&nbsp;';
		var preview 	= '<?php echo @$image_button; ?>';
       // return previewBtn
        //return preview + updateBtn;
		return updateBtn;
		
    }	
	
	function edit_view(id_siswa) {
		window.location.href = "<?php echo '#'.$controller.'/form/'; ?>"+id_siswa;
	}
	
	function create_view() {
		window.location.href = "<?php echo '#'.$controller.'/form/'; ?>";
	}
</script>