<?php 
class Role_model extends CI_Model {
	
	function cekRoleName($role) {
		
		$this->db->select("role_id");
		$this->db->from("adm_roles");
		$this->db->where("upper(role_name)",strtoupper($role));
		$num = $this->db->get()->num_rows();
		return $num;
		
	}
	
	function cekRoleNameUpdate($role,$id) {
		
		//get old role 
		$this->db->select("role_name");
		$this->db->from("adm_roles");
		$this->db->where("role_id",$id);
		$oldRole = $this->db->get()->row()->role_name;
		if (strtoupper($oldRole) == strtoupper($role)) {
			$num = 0;
		} else {
			$this->db->select("role_id");
			$this->db->from("adm_roles");
			$this->db->where("upper(role_name)",strtoupper($role));
			$num = $this->db->get()->num_rows();
			
		}		
		return $num;
	}
	
	function delete_data() {
		
		$del = false;
		$role_id = $this->input->post('role_id');
		if (!empty($role_id)) {
			$this->db->where("role_id",$role_id);
			$del = $this->db->delete("adm_roles");
			
		}
		
		return $del;
	}
	
	function get_value_edit($id) {
		$this->db->select('role_status,role_name');
		$this->db->from('adm_roles');
		$this->db->where('role_id',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'adm_roles'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select role_id, role_name, role_status, created_by, created_date, modified_by, modified_date from $table  order by role_id limit ?, ?";
                $sqlcount = "select * from $table";
            } else {
                $sql = "select role_id, role_name, role_status, created_by, created_date, modified_by, modified_date from $table  $cond order by role_id limit ?, ?";
                $sqlcount = "select * from $table $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select role_id, role_name, role_status, created_by, created_date, modified_by, modified_date from $table order by $sort $order limit ?, ?";
                $sqlcount = "select role_id from $table";
            } else {
                $sql = "select role_id, role_name, role_status, created_by, created_date, modified_by, modified_date from $table  $cond order by $sort $order limit ?, ?";
                $sqlcount = "select role_id from $table  $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	function insert_data() {
		
		$data['role_name'] 		= $this->input->post('role_name');
		$data['role_status']	= $this->input->post('role_status');
		$data['created_date']	= date("Y-m-d H:i:s");
		$data['created_by']		= $this->session->userdata('username');
		
		$q = $this->db->insert('adm_roles',$data);
		return $q;	
		
	}
	
	function update_data() {
		
		$id = $this->input->post('role_id');
		
		$data['role_name'] 		= $this->input->post('role_name');
		$data['role_status']	= $this->input->post('role_status');
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		$this->db->where('role_id',$id);
		$q = $this->db->update('adm_roles',$data);
		return $q;	
		
	}
	
}