<?php 
class Rep_siswa_model extends CI_Model {
	
	function get_header($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		if($id_smk=='' || empty($id_smk)){
			$this->db->select("jenispembayaran, id_smk, kelas, id");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->order_by("id_smk","asc");
			$this->db->order_by("kelas","asc");
		}else{
			$this->db->select("jenispembayaran, id_smk, kelas, id");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("id_smk",$id_smk);
			$this->db->order_by("id_smk","asc");
			$this->db->order_by("kelas","asc");
		}
		
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	function get_header_cicilan() {
		
		$q = $this->db->query("SELECT DISTINCT(a.Id), a.kodedesk, a.kodesub, a.daftarlist FROM ref_list_uang_masuk a, ref_komponen_cicilan b WHERE a.Id=b.id_coa");
		$data = $q->result_array();	;
		return $data;
		
	}
	
	function get_cicilan_count_header() {
		
		$q = $this->db->query("SELECT count(DISTINCT(a.Id)) as jum_cicilan FROM ref_list_uang_masuk a, ref_komponen_cicilan b WHERE a.Id=b.id_coa");
		$data = $q->row();	;
		return $data;
		
	}
	function get_count_header($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		if(($id_smk=='') || (empty($id_smk))){
			$this->db->select("id_smk, count(distinct jenispembayaran) as jenis_pem");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->group_by('id_smk');
			$this->db->order_by("id_smk","asc");
		}else{
			$this->db->select("id_smk, count(distinct jenispembayaran) as jenis_pem");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("id_smk",$id_smk);
			$this->db->group_by('id_smk');
			$this->db->order_by("id_smk","asc");
		}
		
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	function get_count_header_cicilan($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		if(($id_smk=='') || (empty($id_smk))){
			$this->db->select("count(distinct jenis_pembayaran) as jenis_pem, id_smk, no_type");
			$this->db->from("ref_komponen_cicilan");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->group_by('id_smk');
			$this->db->group_by('no_type');
			$this->db->order_by("id_smk","asc");
		}else{
			$this->db->select("count(distinct jenis_pembayaran) as jenis_pem, id_smk, no_type");
			$this->db->from("ref_komponen_cicilan");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("id_smk",$id_smk);
			$this->db->group_by('id_smk');
			$this->db->group_by('no_type');
			$this->db->order_by("id_smk","asc");
		}
		
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	
	function get_tahun_ajaran() {
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$data = $this->db->get()->row()->tahun_ajaran;
		return $data;
	}
	
	function get_id_siswa($periode, $smk) {
		if($smk==''){
			$q = $this->db->query("
				select DISTINCT a.id_siswa, a.sts_ppdb from ( 
					SELECT id_siswa, sts_ppdb from trans_siswa where tanggal_pembayaran = '".$periode."'
					UNION ALL 
					SELECT id_siswa, sts_ppdb from trans_spp where tanggal_transaksi = '".$periode."' 
				) a");
		}else{
			$q = $this->db->query("select DISTINCT a.id_siswa, a.sts_ppdb from ( 
				SELECT a.id_siswa, a.sts_ppdb from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL
				SELECT a.id_siswa, a.sts_ppdb from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
			) a");
		}
		
		return $q->result_array();	
	}
	
	/*
	function get_id_siswa($periode, $smk) {
		if($smk==''){
			$q = $this->db->query("
				select DISTINCT a.id_siswa, a.sts_ppdb, a.cicilan from ( 
					SELECT id_siswa, sts_ppdb, cicilan from trans_siswa where tanggal_pembayaran = '".$periode."'
					UNION ALL 
					SELECT id_siswa, sts_ppdb, '0' as cicilan from trans_spp where tanggal_transaksi = '".$periode."' 
				) a");
		}else{
			$q = $this->db->query("select DISTINCT a.id_siswa, a.sts_ppdb, a.cicilan from ( 
				SELECT a.id_siswa, a.sts_ppdb, a.cicilan from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, '0' as cicilan from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL
				SELECT a.id_siswa, a.sts_ppdb, a.cicilan from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, '0' as cicilan from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
			) a");
		}
		
		return $q->result_array();	
	}
	
	*/
	
	function get_detail($id_siswa) {
		//get nama siswa
		$this->db->select("nama");
		$this->db->from("ref_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$return = $this->db->get()->row()->nama.'<br>';
		
		/* //get trans siswa
		$this->db->select("jenis_pembayaran,besarnya");
		$this->db->from("trans_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$t_sis = $this->db->get()->result_array();
		
		foreach ($t_sis as $v_sis) {
			$return .= '--'.$v_sis['jenis_pembayaran'].' - '.$v_sis['besarnya'].'<br>';		
		}

		//get pem spp 	
		$this->db->select("bulan,besarnya");
		$this->db->from("trans_spp");
		$this->db->where("id_siswa",$id_siswa);
		$t_spp = $this->db->get()->result_array();
		
		foreach ($t_spp as $v_spp) {
			$return .= '-- SPP Bulan '.$v_spp['bulan'].' - '.$v_spp['besarnya'].'<br>';		
		} */
		
		return $return;
			
	}
	
	function get_detail_ppdb($id_siswa) {
		//get nama siswa
		$this->db->select("nama");
		$this->db->from("ppdb_siswa");
		$this->db->where("id_daftar",$id_siswa);
		$return = $this->db->get()->row()->nama.'<br>';
		return $return;
			
	}
	
	function getDataSMK(){
		$this->db->select('*');
		$this->db->from("ref_smk");
		$num = $this->db->get()->result_array();
		return $num;
	}
	
	function getSMK($id){
		$this->db->select('name');
		$this->db->from("ref_smk");
		$this->db->where("id",$id);
		$return = $this->db->get()->row();
		return $return;
	}
	
	function get_kelas($id_siswa) {
		 $q = $this->db->query("select kelas from ref_siswa where id_siswa=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->kelas;					
	}
	function get_kelas_ppdb($id_siswa) {
		 $q = $this->db->query("select kelas from ppdb_siswa where id_daftar=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->kelas;					
	}
	
	function get_ruang_kelas($id_siswa) {
		/*
		$this->db->select("id_wali_kelas");
		$this->db->from("ref_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$id_wali = $this->db->get()->row()->id_wali_kelas;
		
		$this->db->select("ruang_kelas");
		$this->db->from("ref_mapping_kelas");
		$this->db->where("id_karyawan",$id_wali);		
		$ruang = $this->db->get()->row()->ruang_kelas;
		*/
		
		//echo $ruang; die();
		//echo $this->db->last_query(); die();
		//return $ruang;
		
		 $q = $this->db->query("select b.name ruang_kelas from ref_siswa a, ref_smk b where a.id_smk=b.id and a.id_siswa=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->ruang_kelas;					
	}
	
	function get_ruang_kelas_ppdb($id_siswa) {
		 $q = $this->db->query("select b.name ruang_kelas from ppdb_siswa a, ref_smk b where a.id_smk=b.id and a.id_daftar=".$id_siswa);				
		return $q->row()->ruang_kelas;					
	}
	
	
	function total_spp_harian($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and b.id_smk=".$smk."");
		}
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
		
	}
	
	function total_spp_harian_ppdb($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and b.id_smk=".$smk."");
		}
		
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
	}
	function total_tabsis_harian($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and SUBSTRING(no_faktur, 1, 2)='FM'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and b.id_smk=".$smk." and SUBSTRING(no_faktur, 1, 2)='FM'");
		}
		
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
	}
	
	function total_tabsis_harian_ppdb($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1  and SUBSTRING(no_faktur, 1, 2)='FM'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and b.id_smk=".$smk."  and SUBSTRING(no_faktur, 1, 2)='FM'");
		}
		
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
	}
	
	function total_cicilan_harian($periode, $smk) {
		
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	function total_cicilan_harian_ppdb($periode, $smk) {
		
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	function get_total_spp_ppdb($id_siswa, $periode) {
		$q = $this->db->query("select sum(besarnya) total from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=1");
		if(($q->row()->total)==NULL){
			return 0; 
		}else{
			return $q->row()->total; 
		}
	}
	function get_total_tabsis_ppdb($id_siswa, $periode) {
		$q = $this->db->query("select sum(besarnya) total from trans_tabsis where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=1 and SUBSTRING(no_faktur, 1, 2)='FM'");
		if(($q->row()->total)==NULL){
			return 0; 
		}else{
			return $q->row()->total; 
		}
		
		
	}
	
	function get_total_spp($id_siswa, $periode) {
		$q = $this->db->query("select sum(besarnya) total from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=0");
		return $q->row()->total; 
		
	}
	
	function get_total_tabsis($id_siswa, $periode) {
		$q = $this->db->query("select sum(besarnya) total from trans_tabsis where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=0  and SUBSTRING(no_faktur, 1, 2)='FM'");
		return $q->row()->total; 
		
	}
	
	function get_total_cicilan($id_siswa, $periode) {
		/*$q = $this->db->query("select sum(besarnya) total from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=0 and kodedesk='".$kodedesk."' and kodesub='".$kodesub."' and tanggal_pembayaran = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FM'");*/
		
		$q = $this->db->query("select sum(besarnya) total from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=0 and tanggal_pembayaran = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FM'");
		$q2 = $this->db->query("select sum(besarnya) total from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=0 and tanggal_pembayaran = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FK'");
		
		$temp1=0;
		$temp2=0;
		if(empty($q->row()->total)||($q->row()->total==NULL)){
			$temp1 =  0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(empty($q2->row()->total)||($q2->row()->total==NULL)){
			$temp2 =  0;
		}else{
			$temp2 =  $q2->row()->total; 
		}
		return $temp1-$temp2;
		
	}
	
	function get_total_cicilan_ppdb($id_siswa, $periode) {
		$q = $this->db->query("select sum(besarnya) total from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=1 and tanggal_pembayaran = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FM'");		
		$q2 = $this->db->query("select sum(besarnya) total from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=1 and tanggal_pembayaran = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FK'");
		
		$temp1=0;
		$temp2=0;
		if(empty($q->row()->total)||($q->row()->total==NULL)){
			$temp1 =  0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(empty($q2->row()->total)||($q2->row()->total==NULL)){
			$temp2 =  0;
		}else{
			$temp2 =  $q2->row()->total; 
		}
		return $temp1-$temp2;
	}
	
	function get_total_bayar_cicilan($id_siswa, $kodedesk, $kodesub) {
		
		$q = $this->db->query("SELECT a.besarnya as total FROM ref_mapping_cicilan_siswa a, ref_komponen_cicilan b, ref_list_uang_masuk c  WHERE a.id_coa=b.id and b.id_coa=c.Id and a.status=1 and a.id_siswa=".$id_siswa." and c.kodedesk='".$kodedesk."' and c.kodesub='".$kodesub."'");
		if(empty($q->row()->total)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
		//$data = $q->result_array();
		
	}
	
	
	function get_total_trans_harian($jenis,$periode, $smk) {
		if($smk==''){
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.id_ref_list_biaya = '".$jenis."' and a.tanggal_pembayaran = '".$periode."' and a.sts_ppdb=0" );
		}else{
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.id_ref_list_biaya = '".$jenis."' and a.tanggal_pembayaran = '".$periode."' and b.id_smk=".$smk." and a.sts_ppdb=0" );
			
			
		}
		return $q->row();
	}
	
	function get_total_trans_harian_ppdb($jenis,$periode, $smk) {
		if($smk==''){
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.id_ref_list_biaya = '".$jenis."' and a.tanggal_pembayaran = '".$periode."' and a.sts_ppdb=1" );
		}else{
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.id_ref_list_biaya = '".$jenis."' and a.tanggal_pembayaran = '".$periode."' and b.id_smk=".$smk." and a.sts_ppdb=1" );
			
			
		}
		return $q->row();
	}
	
	function get_total_trans($id_siswa,$jenis, $periode) {
		$q = $this->db->query("select sum(besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where  a.tanggal_pembayaran = '".$periode."' and a.id_siswa=b.id_siswa and a.id_siswa = ".$id_siswa." and a.id_ref_list_biaya = '".$jenis."' and sts_ppdb=0");
		return $q->row();
	}
	
	function get_total_trans_ppdb($id_siswa,$jenis, $periode) {
		$q = $this->db->query("select sum(besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where  a.tanggal_pembayaran = '".$periode."' and a.id_siswa=b.id_daftar and a.id_siswa = ".$id_siswa." and a.id_ref_list_biaya = '".$jenis."' and sts_ppdb=1");
		return $q->row();
	}
	
}