<?php 
class Ref_spp_type_model extends CI_Model {
	
	function get_tahun_ajaran() {
		
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$tahun = $this->db->get()->row()->tahun_ajaran;
		return $tahun;
		
	}
	
	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("ref_spp_type");
			
		}
		
		return $del;
	}
	
	function get_kodesub() {
	
		$this->db->select("kodesub,daftarlist");
		$this->db->from("ref_list_uang_masuk");
		$this->db->where("kodedesk","I");
		$this->db->where_in("kodesub",array("1","2","3","4","5","6","7","8","9"));
		$data = $this->db->get()->result_array();
		return $data;
		
	}

	function getDataSMK(){
		$this->db->select('*');
		$this->db->from("ref_smk");
		$num = $this->db->get()->result_array();
		return $num;
	}
	
	
	
	
	function get_value_edit($id) {
		$this->db->select('*');
		$this->db->from('ref_spp_type');
		$this->db->where('id',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	
	
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'ref_spp_type'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select a.*, b.name from $table a, ref_smk b where a.id_smk=b.id order by id limit ?, ?";
                $sqlcount = "select a.*, b.name from $table a, ref_smk b where a.id_smk=b.id ";
            } else {
                $sql = "select a.*, b.name from $table a, ref_smk b $cond and a.id_smk=b.id order by id limit ?, ?";
                $sqlcount = "select a.*, b.name from $table a, ref_smk b $cond and a.id_smk=b.id ";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select a.*, b.name from $table a, ref_smk b where a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "select a.*, b.name from $table a, ref_smk b where a.id_smk=b.id ";
            } else {
                $sql = "select a.*, b.name from $table a, ref_smk b $cond and a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "select a.*, b.name from $table a, ref_smk b $cond and a.id_smk=b.id";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	function update_data() {
		$id 					= $this->input->post('id');
		$data['ref_name'] 		= $this->input->post('ref_name');
		$data['tahun_ajaran'] 	= $this->input->post('tahun_ajaran');
		$data['type_dis']		= $this->input->post('type_dis');
		$data['id_smk']			= $this->input->post('smk');	
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		if($data['type_dis']==1){
			$data['besarnya'] 		= 0;
		}else if($data['type_dis']==2){
			$data['besarnya'] 		= $this->input->post('besarnya');
		}else if($data['type_dis']==3){
			$data['besarnya'] 		= 0;
		}else{
			$data['besarnya'] 		= 0;
		}
		
		$this->db->where("id",$id);
		$q = $this->db->update("ref_spp_type",$data);
		
		return $q;	
	}
	
	function insert_data() {
		
		$data['ref_name'] 		= $this->input->post('ref_name');
		$data['tahun_ajaran'] 	= $this->input->post('tahun_ajaran');
		$data['type_dis']		= $this->input->post('type_dis');
		$data['id_smk']			= $this->input->post('smk');	
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		if($data['type_dis']==1){
			$data['besarnya'] 		= 0;
		}else if($data['type_dis']==2){
			$data['besarnya'] 		= $this->input->post('besarnya');
		}else if($data['type_dis']==3){
			$data['besarnya'] 		= 0;
		}else{
			$data['besarnya'] 		= 0;
		}
		
		$q = $this->db->insert("ref_spp_type",$data);
		
		return $q;	
		
	}
	
}